<?php
/**
 * Admin User Generator Script
 * এটি রান করার পর ডিলিট করে দেবেন।
 */

// কনফিগারেশন এবং ডাটাবেস ফাইল লোড করা
// ফাইলটি যদি 'php' ফোল্ডারের ভেতর থাকে, তবে এই পাথগুলো কাজ করবে
require_once 'config.php';
require_once 'admin/includes/db.php';

// আপনি যে ইউজারনেম ও পাসওয়ার্ড চান তা এখানে দিন
$username = 'admin';
$password = '123456'; // লগইন করার পর পাসওয়ার্ড পরিবর্তন করা ভালো

echo "<h1>Admin User Generator</h1>";

try {
    // ডাটাবেস কানেকশন
    $pdo = get_db_connection();
    
    // ১. পাসওয়ার্ড হ্যাশ করা (PHP এর ডিফল্ট সিকিউর অ্যালগরিদম দিয়ে)
    $password_hash = password_hash($password, PASSWORD_DEFAULT);
    
    // ২. পুরনো ইউজার থাকলে ডিলিট করা (যাতে ডুপ্লিকেট এরর না আসে)
    $stmt = $pdo->prepare("DELETE FROM admins WHERE username = ?");
    $stmt->execute([$username]);
    
    // ৩. নতুন ইউজার ইনসার্ট করা
    $stmt = $pdo->prepare("INSERT INTO admins (username, password_hash) VALUES (?, ?)");
    
    if ($stmt->execute([$username, $password_hash])) {
        echo "<p style='color: green; font-size: 18px;'>SUCCESS! ইউজার তৈরি হয়েছে।</p>";
        echo "<ul>";
        echo "<li><strong>Username:</strong> " . htmlspecialchars($username) . "</li>";
        echo "<li><strong>Password:</strong> " . htmlspecialchars($password) . "</li>";
        echo "<li><strong>Hash (Database-e Saved):</strong> " . htmlspecialchars($password_hash) . "</li>";
        echo "</ul>";
        echo "<p><a href='admin/login.php'>এখানে ক্লিক করে লগইন করুন</a></p>";
    } else {
        echo "<p style='color: red;'>ডাটাবেসে ইনসার্ট করা যায়নি।</p>";
    }

} catch (PDOException $e) {
    echo "<p style='color: red;'>Database Error: " . $e->getMessage() . "</p>";
    echo "<p>আপনার config.php ফাইলে ডাটাবেসের নাম এবং পাসওয়ার্ড সঠিক আছে কিনা চেক করুন।</p>";
}
?>