<?php
header('Content-Type: application/json');
require '../db_connect.php';

$headers = getallheaders();
$auth_header = $headers['Authorization'] ?? '';
if (!preg_match('/Bearer\s(\S+)/', $auth_header, $matches)) {
    http_response_code(401);
    echo json_encode(['status' => 'error', 'message' => 'API key is missing or invalid.']);
    exit();
}
$api_key = $matches[1];

$stmt_user = $pdo->prepare("SELECT user_id, base_url FROM settings WHERE api_key = ?");
$stmt_user->execute([$api_key]);
$setting = $stmt_user->fetch(PDO::FETCH_ASSOC);

if (!$setting) {
    http_response_code(403);
    echo json_encode(['status' => 'error', 'message' => 'Invalid API key.']);
    exit();
}
$user_id = $setting['user_id'];
$stored_base_url = $setting['base_url'] ?? '';

$json_data = file_get_contents('php://input');
$data = json_decode($json_data, true);

$client_base_url = $data['client_base_url'] ?? '';

// ★★★ নতুন পরিবর্তন: এখন এরর লগ একটি নির্দিষ্ট ফাইলে সেভ হবে ★★★
if (empty($client_base_url) || rtrim($stored_base_url, '/') !== rtrim($client_base_url, '/')) {
    
    // ১. লগ ফাইলের পাথ নির্ধারণ করা হয়েছে (dashboard_project/error_log)
    $log_file_path = __DIR__ . '/../error_log';

    // ২. লগ মেসেজ ফরম্যাট করা হয়েছে (তারিখ, সময়সহ)
    $timestamp = date('d-M-Y H:i:s e');
    $log_entry = sprintf(
        "[%s] API Domain Mismatch: Expected URL='%s', Received URL='%s'\n",
        $timestamp,
        $stored_base_url,
        $client_base_url ?: '[URL Not Provided]'
    );

    // ৩. error_log ফাইলে মেসেজটি যুক্ত করা হচ্ছে
    file_put_contents($log_file_path, $log_entry, FILE_APPEND | LOCK_EX);

    // ৪. ক্লায়েন্টকে আগের মতোই এরর রেসপন্স পাঠানো হচ্ছে
    http_response_code(403);
    echo json_encode([
        'status' => 'error', 
        'message' => 'Domain mismatch. দুঃখিত, সংযোগ স্থাপন করা যায়নি।'
    ]);
    exit();
}
// ★★★ পরিবর্তন শেষ ★★★

$amount = $data['amount'] ?? 0;
if ($amount <= 0) {
    http_response_code(400);
    echo json_encode(['status' => 'error', 'message' => 'Amount must be greater than zero.']);
    exit();
}

try {
    $unique_id = sha1(uniqid(rand(), true) . microtime()); 

    $sql = "INSERT INTO transactions (user_id, unique_id, amount, customer_name, customer_email, success_url, cancel_url, meta_data) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
    
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        $user_id,
        $unique_id,
        $amount,
        $data['customer_name'] ?? null,
        $data['customer_email'] ?? null,
        $data['success_url'] ?? null,
        $data['cancel_url'] ?? null,
        $data['meta_data'] ?? null
    ]);
    
    if (empty($stored_base_url)) {
        throw new Exception("Base URL is not configured in API settings.");
    }
    $project_root_url = str_replace('/api', '', $stored_base_url);
    $payment_url = "{$project_root_url}/checkout.php?trx_id={$unique_id}";

    http_response_code(201);
    echo json_encode(['status' => 'success', 'payment_url' => $payment_url]);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => 'Failed to create transaction.', 'error_details' => $e->getMessage()]);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
?>