<?php
// ডেটাবেস সংযোগ ফাইল যুক্ত করা
require 'db_connect.php';
// ব্যবহারকারী লগইন করা আছে কিনা তা নিশ্চিত করা
require 'auth_check.php';

// শুধুমাত্র POST রিকোয়েস্ট গ্রহণ করা হবে
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $gateway_key = $_POST['gateway_key'];
    $user_id = $_SESSION['user_id']; 

    // গেটওয়ে কী-এর উপর ভিত্তি করে একটি ডিফল্ট নাম সেট করা
    $display_name = '';
    if ($gateway_key === 'bkash_personal') $display_name = 'Bkash Personal';
    else if ($gateway_key === 'nagad_personal') $display_name = 'Nagad Personal';
    else if ($gateway_key === 'rocket_personal') $display_name = 'Rocket Personal';
    else if ($gateway_key === 'upay_personal') $display_name = 'Upay Personal';
    else if ($gateway_key === 'bkash_merchant_tokenized') $display_name = 'bKash Marchant (Tokenized)';
    else if ($gateway_key === 'nagad_merchant') $display_name = 'Nagad Marchant';
    // ★★★ bKash Marchant (Checkout)-এর জন্য নতুন শর্ত যুক্ত করা হয়েছে ★★★
    else if ($gateway_key === 'bkash_merchant_checkout') $display_name = 'bKash Marchant (Checkout)';


    if (!empty($display_name)) {
        try {
            $sql = "INSERT INTO gateways (user_id, display_name, gateway_key) 
                    VALUES (:user_id, :display_name, :gateway_key)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                'user_id' => $user_id,
                'display_name' => $display_name,
                'gateway_key' => $gateway_key
            ]);
        } catch (PDOException $e) {
            die("Error creating gateway: " . $e->getMessage());
        }
    }
}

header("Location: payment.php");
exit();