<?php
session_start();
error_reporting(E_ALL);
ini_set('display_errors', 1);

define('STEPS', ['welcome', 'license', 'database', 'finish']);

$current_step = $_GET['step'] ?? 'welcome';

// Ensure steps are followed in order
if (!isset($_SESSION['max_step'])) {
    $_SESSION['max_step'] = 'welcome';
}

$current_step_index = array_search($current_step, STEPS);
$max_step_index = array_search($_SESSION['max_step'], STEPS);

if ($current_step_index > $max_step_index) {
    header('Location: index.php?step=' . $_SESSION['max_step']);
    exit();
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $next_step = '';

    if ($action === 'verify_license') {
        $license_key = trim($_POST['license_key']);
        $item_name = 'Your Item Name'; // ★★★ আপনার WHMCS প্রোডাক্টের Item Name দিন
        $license_server_url = 'https://securesoftpay.settings.top/modules/addons/my_license_validator/api.php'; // ★★★ আপনার লাইসেন্স সার্ভারের URL

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $license_server_url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'action' => 'check',
            'license_key' => $license_key,
            'item_name' => $item_name
        ]));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        curl_close($ch);
        $result = json_decode($response, true);

        if ($result && isset($result['success']) && $result['success'] && $result['status'] === 'active') {
            $_SESSION['license_key'] = $license_key;
            $_SESSION['message'] = ['type' => 'success', 'text' => 'License key is valid!'];
            $next_step = 'database';
        } else {
            $_SESSION['message'] = ['type' => 'error', 'text' => $result['message'] ?? 'Invalid or inactive license key.'];
            $next_step = 'license';
        }
    } elseif ($action === 'setup_database') {
        $db_host = $_POST['db_host'];
        $db_name = $_POST['db_name'];
        $db_user = $_POST['db_user'];
        $db_pass = $_POST['db_pass'];

        try {
            $pdo = new PDO("mysql:host=$db_host;dbname=$db_name", $db_user, $db_pass);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            // Create config file
            $config_content = "<?php\n";
            $config_content .= "define('DB_HOST', '" . addslashes($db_host) . "');\n";
            $config_content .= "define('DB_NAME', '" . addslashes($db_name) . "');\n";
            $config_content .= "define('DB_USER', '" . addslashes($db_user) . "');\n";
            $config_content .= "define('DB_PASS', '" . addslashes($db_pass) . "');\n";
            file_put_contents('../config.php', $config_content);

            // Import database schema
            $schema_sql = file_get_contents('schema.sql');
            $pdo->exec($schema_sql);
            
            $_SESSION['db_success'] = true;
            $next_step = 'finish';

        } catch (PDOException $e) {
            $_SESSION['message'] = ['type' => 'error', 'text' => 'Database connection failed: ' . $e->getMessage()];
            $next_step = 'database';
        }
    }

    if ($next_step) {
        $next_step_index = array_search($next_step, STEPS);
        if ($next_step_index > $max_step_index) {
            $_SESSION['max_step'] = $next_step;
        }
        header('Location: index.php?step=' . $next_step);
        exit();
    }
}

// Display the current step view
include "views/{$current_step}.php";

?>