<?php
// This part should be at the very top of the file before any HTML output.
if (isset($_SESSION['db_success']) && !isset($_SESSION['admin_credentials'])) {
    // Call your central server to create admin credentials
    $central_api_url = 'https://settings.top/dashboard_project/api/create_instance_admin.php'; // ★★★ আপনার মূল সার্ভারের API URL
    $license_key = $_SESSION['license_key'];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $central_api_url);
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'license_key' => $license_key,
        // For better security, you should add a master API key here.
        // 'master_key' => 'your_secret_master_key'
    ]));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    $result = json_decode($response, true);

    if ($result && isset($result['success']) && $result['success']) {
        $_SESSION['admin_credentials'] = $result['credentials'];
    } else {
        $_SESSION['admin_credentials'] = ['error' => $result['message'] ?? 'Could not create admin user from the central server.'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Installation Finished - Setup Wizard</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <h1>Installation Complete!</h1>
        <p class="success">Your application has been installed successfully.</p>

        <div class="content">
            <h3>Your Admin Login Details</h3>
            <?php if (isset($_SESSION['admin_credentials']) && !isset($_SESSION['admin_credentials']['error'])): ?>
                <div class="form-group">
                    <label>Username</label>
                    <input type="text" value="<?php echo htmlspecialchars($_SESSION['admin_credentials']['username']); ?>" readonly>
                </div>
                 <div class="form-group">
                    <label>Password</label>
                    <input type="text" value="<?php echo htmlspecialchars($_SESSION['admin_credentials']['password']); ?>" readonly>
                </div>
                <p>Please save these details in a secure location. You will use these to log in.</p>
            <?php else: ?>
                <p class="error"><?php echo htmlspecialchars($_SESSION['admin_credentials']['error'] ?? 'An unknown error occurred while creating your admin account.'); ?></p>
            <?php endif; ?>
        </div>

        <div class="warning">
            <h3><strong>IMPORTANT:</strong> Delete the Install Directory</h3>
            <p>For security reasons, you must now delete the <strong>/install/</strong> directory from your server before you can log in.</p>
        </div>
        <br>
        <a href="../login.php" class="button">Go to Login Page</a>
    </div>
</body>
</html>