<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Welcome - Setup Wizard</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="container">
        <h1>Welcome to the Setup Wizard</h1>
        <p>This wizard will guide you through the installation process. Please ensure your server meets the following requirements.</p>
        <div class="content">
            <h3>Server Requirements</h3>
            <ul>
                <?php
                    $php_version_ok = version_compare(phpversion(), '7.4.0', '>=');
                    $curl_ok = extension_loaded('curl');
                    $pdo_ok = extension_loaded('pdo_mysql');
                    $all_ok = $php_version_ok && $curl_ok && $pdo_ok;
                ?>
                <li>PHP Version >= 7.4: <span class="<?php echo $php_version_ok ? 'success' : 'error'; ?>"><?php echo phpversion(); ?></span></li>
                <li>cURL Extension Enabled: <span class="<?php echo $curl_ok ? 'success' : 'error'; ?>"><?php echo $curl_ok ? 'Yes' : 'No'; ?></span></li>
                <li>PDO MySQL Extension Enabled: <span class="<?php echo $pdo_ok ? 'success' : 'error'; ?>"><?php echo $pdo_ok ? 'Yes' : 'No'; ?></span></li>
            </ul>
        </div>
        <br>
        <form action="index.php" method="GET">
             <input type="hidden" name="step" value="license">
             <button type="submit" class="button" <?php echo !$all_ok ? 'disabled' : ''; ?>>
                <?php echo $all_ok ? 'Start Setup' : 'Requirements Not Met'; ?>
             </button>
        </form>
    </div>
</body>
</html>