<?php
session_start();

// যদি ব্যবহারকারী ইতিমধ্যে লগইন করা থাকে, তাকে ড্যাশবোর্ডে পাঠিয়ে দেওয়া হবে
if (isset($_SESSION['user_logged_in']) && $_SESSION['user_logged_in'] === true) {
    header("Location: index.php");
    exit();
}

// ইনস্টলার ফাইল config.php তৈরি করেছে কিনা তা পরীক্ষা করা
if (!file_exists(__DIR__ . '/config.php')) {
    // যদি config.php না থাকে, তাহলে স্বয়ংক্রিয়ভাবে install ফোল্ডারে পাঠিয়ে দেওয়া হবে
    header('Location: install/index.php');
    exit;
}
require_once __DIR__ . '/config.php'; // ইনস্টলার দ্বারা তৈরি কনফিগ ফাইল

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // ★★★ এই URL টি আপনার কেন্দ্রীয় সার্ভারের হবে ★★★
    $central_api_url = 'https://settings.top/dashboard_project/api/validate_login.php';

    // লাইসেন্স কী config.php থেকে লোড করা হবে (ইনস্টলার এটি তৈরি করবে)
    $license_key = defined('LICENSE_KEY') ? LICENSE_KEY : '';

    if (empty($license_key)) {
        $error = 'License key is missing from the configuration file. Please reinstall the application.';
    } else {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $central_api_url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
            'username' => $username,
            'password' => $password,
            'license_key' => $license_key
        ]));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($ch);
        $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        $result = json_decode($response, true);

        if ($http_code === 200 && $result && isset($result['success']) && $result['success']) {
            $_SESSION['user_logged_in'] = true;
            $_SESSION['username'] = $username;
            header("Location: index.php");
            exit();
        } else {
            $error = $result['message'] ?? 'Login failed. An unknown error occurred.';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Login</title>
    <link rel="stylesheet" href="css/style.css?v=<?php echo @filemtime('css/style.css'); ?>">
</head>
<body class="auth-body">
    <div class="auth-container">
        <h2 class="auth-title">Dashboard Login</h2>
        <?php if (!empty($error)): ?>
            <div class="auth-errors"><p><?php echo htmlspecialchars($error); ?></p></div>
        <?php endif; ?>
        <form action="login.php" method="POST">
            <div class="form-group">
                <label for="username">Username</label>
                <input type="text" id="username" name="username" required>
            </div>
            <div class="form-group">
                <label for="password">Password</label>
                <input type="password" id="password" name="password" required>
            </div>
            <button type="submit" class="btn btn-primary auth-btn">Login</button>
        </form>
    </div>
</body>
</html>